//
// $Id: fmmouse.cc,v 1.6 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

#include "bochs.h"
#if BX_EMULATION_TOWNS
#define LOG_THIS this->

unsigned bx_fmmouse_c::timer_handle = 0;
bx_fmmouse_c *bx_fmmouse_c::activemouse = NULL;

bx_fmmouse_c::~bx_fmmouse_c(void)
{
  if(is_active) {
    bx_pc_system.deactivate_timer(timer_handle);
    activemouse = NULL;
    bx_gui.set_mouse_motion_handler(NULL);
  }
}

void bx_fmmouse_c::init(bx_devices_c *d, bx_padport_c *p, int n)
{
  bx_pad_c::init(d,p,n);
  if(timer_handle == 0) {
    timer_handle = bx_pc_system.register_timer(this,
					       timer_handler,
					       600,
					       0,
					       0);
  }
  if(activemouse != NULL) {
    bx_pc_system.deactivate_timer(timer_handle);
    activemouse->is_active = 0;
  }
  bx_gui.set_mouse_motion_handler(motion_handler);
  is_active = 1;
  activemouse = this;
  x=y=0;
  lastport=0;
  button=0;
  state=NO_START0;
}

Bit8u bx_fmmouse_c::read(void)
{
  Bit8u ret;
#define RETURN(x) do { ret = (x); goto read_return; } while (0)

  if (!is_active) RETURN((lastport << 4) & 0x70);

  switch(state) {
  case bx_fmmouse_c::HIGH_X:
    RETURN((((lastport & (~button)) << 4) & 0x70) | ((curx >> 4) & 0x0f));
  case bx_fmmouse_c::LOW_X:
    RETURN((((lastport & (~button)) << 4) & 0x70) | ( curx       & 0x0f));
  case bx_fmmouse_c::HIGH_Y:
    RETURN((((lastport & (~button)) << 4) & 0x70) | ((cury >> 4) & 0x0f));
  case bx_fmmouse_c::LOW_Y:
    RETURN((((lastport & (~button)) << 4) & 0x70) | ( cury       & 0x0f));
  default:
    RETURN (((lastport & (~button)) << 4) & 0x70);
  }

  read_return:
  if (bx_dbg.mouse)
    BX_INFO(("fmmouse: read %.2x from port %d.\n",ret,portno));
  return(ret);
}

void bx_fmmouse_c::write(Bit8u value)
{
  if (bx_dbg.mouse)
    BX_INFO(("fmmouse: write %.2x to port %d.\n",value,portno));

  lastport=value;

  if (!is_active) return;

  if(state==bx_fmmouse_c::NO_START0 && (value & 4) != 0) {
    state=bx_fmmouse_c::HIGH_X;

    if(x > 127) {
      curx = 127;
    } else if(x < -128) {
      curx = -128;
    } else {
      curx = x;
    }
    x -= curx;

    if(y > 127) {
      cury = 127;
    } else if(y < -128) {
      cury = -128;
    } else {
      cury = y;
    }
    y -= cury;

    goto updatetm;
  } else if(state==bx_fmmouse_c::NO_START1 && (value & 4) == 0) {
    state=bx_fmmouse_c::NO_START0;
    goto updatetm;
  } else if(state==bx_fmmouse_c::HIGH_X && (value & 4) == 0) {
    state=bx_fmmouse_c::LOW_X;
    goto updatetm;
  } else if(state==bx_fmmouse_c::LOW_X && (value & 4) != 0) {
    state=bx_fmmouse_c::HIGH_Y;
    goto updatetm;
  } else if(state==bx_fmmouse_c::HIGH_Y && (value & 4) == 0) {
    state=bx_fmmouse_c::LOW_Y;
    goto updatetm;
  }
  return;

updatetm:
  bx_pc_system.activate_timer(timer_handle,0,0);
  return;
}

void bx_fmmouse_c::motion_handler(int delta_x, int delta_y, unsigned button_state)
{
  activemouse->motion(delta_x,delta_y,button_state);
}

void bx_fmmouse_c::motion(int delta_x, int delta_y, unsigned button_state)
{
  x-=delta_x;
  y+=delta_y;
  button=button_state;
}

void bx_fmmouse_c::timer_handler(void *)
{
  activemouse->timer();
}

void bx_fmmouse_c::timer(void)
{
  if((lastport & 0x4) == 0) {
    state = NO_START0;
  } else {
    state = NO_START1;
  }
}
#endif
